<?php


namespace App\Controllers;

use \App\Maps\Controller;
use \App\Models\Admins;
use \App\Providers\Shared;
use \App\Providers\Auth;

/**
*
*/
class Login extends Controller
{
    protected $code = 'login';
    protected $title = 'Connexion';


    public function main()
    {

        Auth::BlockConnected();

    	if ( isset($_POST['submit']) ) {

    		$username = htmlspecialchars(htmlentities($_POST['username']));
    		$password = htmlspecialchars(htmlentities($_POST['password']));

    		$admin = Admins::read($username, $password);

    		if ( !$admin ) {
                Shared::Redirect( $_ENV['BASE_URL'] . 'login/?msg=' . "Identifiants ou mot de passe invalide." );
    			die();
    		}

    		$_SESSION['admin']['id'] = $admin->admin_id;
    		$_SESSION['admin']['username'] = $admin->admin_username;

    		Shared::Redirect( $_ENV['BASE_URL'] . 'dashboard/' );

    	}


        $this->view('login');
    }
}
