<?php


namespace App\Controllers;

use \App\Maps\Controller;
use \App\Providers\Shared;
use \App\Providers\Auth;
use \App\Models\Users;
use \App\Models\Settings;
use \App\Models\Transactions;

/**
*
*/
class User extends Controller
{
    protected $code = 'user';
    protected $title = 'User Profil';


    public function main(int $id)
    {

        Auth::BlockVisitor();

    	$this->user = Users::read($id);

    	$this->alltransactions = Transactions::read($id);

    	$this->solde = Shared::getSolde( $this->alltransactions );

    	$this->settings = Settings::all();

        $this->montant = [ 
            $this->user->montant1, 
            $this->user->montant2, 
            $this->user->montant3, 
            $this->user->montant4
        ];


        if ( isset($_GET['action']) ) {
            
            if ( $_GET['action'] == 'activate' ) {
                Users::active($id , 'Y');
                Shared::Redirect( $_ENV['BASE_URL'] . "user/$id/" );
            }

            if ( $_GET['action'] == 'desactivate' ) {
                Users::active($id , 'N');
                Shared::Redirect( $_ENV['BASE_URL'] . "user/$id/" );
            }

        }


        if ( isset($_POST['update_code']) ) {
            $userid = $this->user->user_id;
            Users::setMontant($userid, $_POST['update_code'], $_POST['code_amount']);
            Shared::Redirect( $_ENV['BASE_URL'] . "user/$userid/" );
        }


    	if ( isset($_POST['submit']) ) {


    		$userid = htmlspecialchars(htmlentities($id));
    		$description = htmlspecialchars(htmlentities($_POST['description']));
    		$type = htmlspecialchars(htmlentities($_POST['type']));
    		$amount = htmlspecialchars(htmlentities($_POST['amount']));


    		$action = Transactions::create($userid, $description, $type, $amount);
    		
    		Shared::Redirect( $_ENV['BASE_URL'] . "user/$userid/" );
    	}


    	$this->view('user');
    	
        
    }
}
