<?php


namespace App\Models;

use \App\Maps\Model;

/**
*
*/
class Users extends Model
{

    public static function all()
    {

        global $db;

        $query = "SELECT * FROM users ;";
        $parameters = [];

        return $db->all($query, $parameters);
    }

    public static function read(int $id)
    {

    	global $db;

        $query = "SELECT * FROM users WHERE user_id = :id ;";
        $parameters = [
            'id' => $id
        ];

        return $db->run($query, $parameters);
    }

    public static function delete(int $id)
    {
        global $db;

        $query = "DELETE FROM users WHERE user_id = :id ;";
        $parameters = [
            'id' => $id
        ];

        return $db->count($query, $parameters);
    }




    public static function login($email)
    {

        global $db;

        $query = "SELECT * FROM users WHERE user_email = :value ;";
        $parameters = [
            'value' => $email
        ];

        return $db->run($query, $parameters);
    }




    public static function create($nom, $prenom, $gender, $email, $compte, $pays, $password)
    {
        global $db;

        $query = "
            INSERT INTO users ( user_nom, user_prenom, user_gender, user_email, user_compte, user_pays, user_password ) 
                VALUES ( :nom, :prenom, :gender, :email, :compte, :pays, :password ) 
            ;
        ";
        $parameters = [
            'nom' => $nom,
            'prenom' => $prenom,
            'gender' => $gender,
            'email' => $email,
            'compte' => $compte,
            'pays' => $pays,
            'password' => $password
        ];

        return $db->count($query, $parameters);
    }



    public static function active($id, $enum)
    {
        global $db;

        $query = "
            UPDATE users 
            SET user_active = :enum
            WHERE user_id = :id 
            ;
        ";
        $parameters = [
            'enum' => $enum,
            'id' => $id
        ];

        return $db->count($query, $parameters);
    }


    public static function setMontant($user_id, $set, $valeur)
    {

        global $db;

        switch ($set) {
            case 1:
                $query = "UPDATE users SET montant1 = :valeur WHERE  user_id = :id ;";
                break;
            case 2:
                $query = "UPDATE users SET montant2 = :valeur WHERE  user_id = :id ;";
                break;
            case 3:
                $query = "UPDATE users SET montant3 = :valeur WHERE  user_id = :id ;";
                break;
            case 4:
                $query = "UPDATE users SET montant4 = :valeur WHERE  user_id = :id ;";
                break;
        }
        
        $parameters = [
            'id' => $user_id,
            'valeur' => $valeur
        ];

        return $db->run($query, $parameters);
    }


}
