<?php


namespace App\Providers;

use \PDO;
use \PDOException;
use \Exception;

/**
*
*/
class Database
{
    private $format = [
        'array' => PDO::FETCH_ASSOC ,
        'object' => PDO::FETCH_OBJ
    ];

    private $xz= "dsd";
    

    protected function connect(string $dsn, string $user, string $pass)
    {
        $pdo = null;

        try {
            $pdo = new PDO($dsn, $user, $pass);
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), 1);
        }

        return $pdo;
    }


    protected function outputFormat(string $returnAs = 'object')
    {
        if (!$this->isFormatExist($returnAs)) {
            $returnAs = 'object';
        }

        return $this->format[$returnAs];
    }


    protected function addFormat(array $formats)
    {
        foreach ($formats as $returnAs => $format) {
            if (!$this->isFormatExist($returnAs)) {
                $this->format[$returnAs] = $format;
            }
        }
    }


    protected function isFormatExist(string $returnAs)
    {
        return array_key_exists($returnAs, $this->format);
    }
}
