<?php


namespace App\Providers;

use \Phroute\Phroute\RouteCollector;
use \Phroute\Phroute\Dispatcher;
use \Exception;

/**
*
*/
class Router
{
    public static function Match(string $method, string $uri)
    {
        $router = new RouteCollector();

        self::RoutesLoader($router);
        
        $dispatcher =  new Dispatcher($router->getData());

        return $dispatcher->dispatch($method, $uri);
    }


    private static function RoutesLoader($router):void
    {
        /* get element in routes directory */
        $routes = Shared::ProperScandir(_ROOT . '/Routes/');

        /* load each valid file .php file */
        foreach ($routes as $route) {
            if (preg_match("/(.php)/i", $route)) {
                require(_ROOT . "/Routes/$route");
            }
        }
    }
}
