<?php


namespace App;

class Server
{
    public function __construct()
    {
        $this->init();
    }


    public function serve()
    {
        \App\Providers\Router::Match(
            $_SERVER['REQUEST_METHOD'],
            parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH)
        );

        return $this;
    }


    private function init()
    {
        $this
            ->resolver()
            ->environment()
            ->database()
        ;

        return $this;
    }


    private function resolver()
    {
        define('_ROOT', __DIR__);

        return $this;
    }


    private function environment()
    {
        $dotenv = \Dotenv\Dotenv::createMutable(_ROOT);
        $dotenv->load();

        return $this;
    }


    private function database()
    {
        $GLOBALS['db'] = new \App\Providers\DBMySql(
            $_ENV['DB_HOST'],
            $_ENV['DB_NAME'],
            $_ENV['DB_USER'],
            $_ENV['DB_PASS']
        );

        return $this;
    }
}
