<?php


session_start();
require( 'app/admin/vendor/autoload.php' );


try {


	$dotenv = \Dotenv\Dotenv::createMutable( "app/admin/" );
    $dotenv->load();


	$GLOBALS['db'] = new \App\Providers\DBMySql(
	    $_ENV['DB_HOST'],
	    $_ENV['DB_NAME'],
	    $_ENV['DB_USER'],
	    $_ENV['DB_PASS']
	);

	
	if ( isset($_GET['action']) && count($_POST) > 0 ) {

		switch ( $_GET['action'] ) {
			case 'loan':
				Loan();
				break;
			case 'login':
	            Login();
				break;
			case 'register':
				Register();
				break;
			case 'contact':
				Contact();
				break;
			default:
				header("Location:/");
				break;
		}
		
	}


} catch (Exception $e) {

	$type = "danger";
	$message = "SYSTEM ERROR [!] " . $e->getMessage();

	header("Location:/message.php?type=$type&message=$message");
	die();
	
}



function Loan()
{
    
    unset($_POST['submit']);

	$fullM = "";

	foreach ($_POST as $key => $value) {
	    $key = strtoupper($key);
		$fullM .= "<b>$key</b> : $value <br>"; 
	}
	
	$mail = sendmail($fullM, $_POST['email'], "FORMULAIRE DE PRET");

	if( !$mail ) {
		$type = "danger";
		$message = "Impossible d'envoyer ce message.";
	} else {
		$type = "success";
		$message = "Message Envoyer";
	}

	header("Location:/message.php?type=$type&message=$message");
	die();
}


function Login()
{
	global $db;

	$email = $_POST['email'];
	$password = $_POST['password'];


	$user = \App\Models\Users::login($email);
	
	//var_dump($user); die();


	if ( !$user ) {
		$type = "danger";
		$message = "Impossible de se connecter.";
		header("Location:/message.php?type=$type&message=$message");
		die();
	}

	if ( $user->user_active != "Y" ) {
		$type = "danger";
		$message = "Votre compte n'est pas encore actif. <br> Contacter contact@gfagroups.agency.";
		header("Location:/message.php?type=$type&message=$message");
		die();
	}

	if ( $user->user_password != $password ) {
		$type = "danger";
		$message = "Mot de passe incorrect.";
		header("Location:/message.php?type=$type&message=$message");
		die();
	}

	$_SESSION['user_id'] = $user->user_id;

	header("Location:/mon-compte.php");

}


function Register()
{
	global $db;


	$nom = $_POST['nom'];
	$prenom = $_POST['prenom'];
	$gender = $_POST['gender'];
	$email = $_POST['email'];
	$compte = $_POST['motif'];
	$pays = $_POST['pays'];
	$password = $_POST['password'];

	$fullM = "";

	foreach ($_POST as $key => $value) {
	    $key = strtoupper($key);
		$fullM .= "<b>$key</b> : $value <br>"; 
	}


	$user = \App\Models\Users::create($nom, $prenom, $gender, $email, $compte, $pays, $password);

	if ( $user ) {
		$type = "success";
		$message = "Inscription envoyée... <br>Nous vous enverrons vos identifiants de connexion dans les plus brefs délais. <br><br>Merci !";

		$mail = sendmail($message, "contact@gfagroups.agency", "INSCRIPTION : EHG GROUPS BANQ", $email , "$nom $prenom");

		$mail = sendmail($fullM, $_POST['email'], "NOUVELLE INSCRIPTION : EHG GROUPS BANQ");

	} else {
		$type = "danger";
		$message = "Impossible de se créer le compte.";
	}

	header("Location:/message.php?type=$type&message=$message");
	die();
}



function Contact()
{
    
    unset($_POST['submit']);

	$fullM = "";

	foreach ($_POST as $key => $value) {
	    $key = strtoupper($key);
		$fullM .= "<b>$key</b> : $value <br>"; 
	}
	
	$mail = sendmail($fullM, $_POST['email'], "FORMULAIRE DE CONTACT");

	if( !$mail ) {
		$type = "danger";
		$message = "Impossible d'envoyer ce message.";
	} else {
		$type = "success";
		$message = "Message Envoyer";
	}

	header("Location:/message.php?type=$type&message=$message");
	die();

}



function sendmail($message, $from, $subject, $to="contact@gfagroups.agency" , $toname="EHG GROUPS BANQ"){


    $mail = new \PHPMailer\PHPMailer\PHPMailer;
    $mail->setFrom($from);
    $mail->addAddress($to, $toname);
    $mail->isHTML(true);
    $mail->Subject  = $subject;
    $mail->Body     = $message;

    return $mail->send() ;

}



