<?php 

	require ('utilities.php');

	@session_start();
	checklogin();

	global $db;

	$title = "Transactions"; 

	// --------------------------------


	$user = $db->run ( 
		"SELECT * FROM users WHERE user_id = :id ;", 
		[ 'id' => $_SESSION['user_id'] ]
	);

    $alltransactions = $db->all ( 
    	"SELECT * FROM transactions WHERE user_id = :id ORDER BY trans_date DESC ;", 
    	[ 'id' => $_SESSION['user_id'] ]
    );

	
	

?>
<?php require( 'partials/_header.php'); ?>





		
      <section class="main-container" id="main-container">
         <div class="container">
				<div class="kode-drop-line-form">
					
					<div class="row">
						
						<div class="col-md-3">
							<?php require( 'partials/_menu.php'); ?>
						</div>
						<div class="col-md-6">

	                        <div class="panel panel-default">
	                <div class="panel-heading">
	                    <h3 class="text-bold">Historiques des transactions</h3>
	                </div>
	                <div class="panel-body">
	                    <section class="table-responsive">
	                        <table class="table table-striped table-bordered">
	                            <thead>
	                                <tr>
	                                    <th>DATE</th>
	                                    <th>MONTANT</th>
	                                    <th>DESCRIPTION</th>
	                                    <th>STATUTS</th>
	                                </tr>
	                            </thead>
	                            <tbody>
	                            	<?php foreach ($alltransactions as $trans): ?>
	                            		<tr>
	                            			<th><?= $trans->trans_date ?></th>
	                            			<th><?= $trans->trans_amount ?> EUR EURO</th>
	                            			<th><?= $trans->trans_description ?></th>
	                            			<th><?= $trans->trans_status ?></th>
	                            		</tr>
	                            	<?php endforeach ?>
	                            </tbody>
	                        </table>
	                    </section>
	                </div>
	            </div>

						</div>
						<div class="col-md-3">
							<?php require( 'partials/_profil.php'); ?>
						</div>
					</div>

				</div>
			</div>
		</section>






<?php require( 'partials/_footer.php'); ?>