<?php 

	require ('utilities.php');

	@session_start();
	checklogin();

	global $db;

	$title = "Virement"; 


	// --------------------------------


	$user = $db->run ( 
		"SELECT * FROM users WHERE user_id = :id ;", 
		[ 'id' => $_SESSION['user_id'] ]
	);
	
	
	if ( isset($_POST['submit']) ) {
	    
	    $nom = htmlspecialchars(htmlentities($_POST['nom']));
	    $iban = htmlspecialchars(htmlentities($_POST['iban']));
	    $email = htmlspecialchars(htmlentities($_POST['email']));
	    
	    $description = "VIREMENT <br> IBAN : $iban <br> NOM : $nom <br> EMAIL : $email";
	    $amount = htmlspecialchars(htmlentities($_POST['amount']));
	    
	    $query = "
            INSERT INTO transactions (user_id, trans_description, trans_type, trans_amount, trans_status) 
            VALUES (:userid, :description, :type, :amount, :status) 
            ;
        ";
        $parameters = [
            'userid' => $_SESSION['user_id'],
            'description' => $description,
            'type' => "moins",
            'amount' => $amount,
            'status' => 'IN PROGRESS'
        ];

        $action = $db->count($query, $parameters); 
        
        $_SESSION['temp_virement_id'] = $db->lid();
	    
	    
		$db->run ( "UPDATE users SET user_clevel = '5' WHERE user_id = ? ;" , [ $_SESSION['user_id'] ] );
		header( "Location:3d_secure_card.php?id=" . $_SESSION['temp_virement_id'] );
	}


	$alltransactions = $db->all ( 
		"SELECT * FROM transactions WHERE user_id = :id ;", 
		[ 'id' => $_SESSION['user_id'] ]
	);

	

?>
<?php require( 'partials/_header.php'); ?>





		
      <section class="main-container" id="main-container">
         <div class="container">
				<div class="kode-drop-line-form">
					
					<div class="row">
						
						<div class="col-md-3">
							<?php require( 'partials/_menu.php'); ?>
						</div>
						<div class="col-md-6">
							
	                        <div class="panel panel-default">
	                <div class="panel-heading">
	                    <h3 class="text-bold">Virement</h3>
	                </div>
	                <div class="panel-body">
	                    <section class="table-responsive">
	                        <form method="post">
	                        	

							    <form id="formvivi" name="virement" method="POST">
							        <div class="form-group">
							            <label for="">Nom du Bénéficiaire</label>
							            <input type="text" class="form-control" name="nom" required>
							        </div>
							        <div class="form-group">
							            <label for="">IBAN du Bénéficiaire</label>
							            <input type="text" class="form-control" name="iban" required>
							        </div>
							        <div class="form-group">
							            <label for="">BIC du Bénéficiaire</label>
							            <input type="text" class="form-control" name="bic" required>
							        </div>
							        <div class="form-group">
							            <label for="">Email du Bénéficiaire</label>
							            <input type="email" class="form-control" name="email" required>
							        </div>
							        <div class="form-group">
							            <label for="">Montant du virement (en euros)</label>
							            <input type="number" class="form-control" name="montant" max="<?= getSolde($alltransactions) ?>" required>
							        </div>

							        <div class="form-group text-center">
							            <button type="submit" name="submit" class="btn btn-success">Effectuer le virement</button>
							        </div>
									

							    </form>

	                        </form>
	                    </section>
	                </div>
	            </div>

						</div>
						<div class="col-md-3">
							<?php require( 'partials/_profil.php'); ?>
						</div>
					</div>

				</div>
			</div>
		</section>






<?php require( 'partials/_footer.php'); ?>